<?php

namespace Drupal\openai_batch\Plugin\QueueWorker;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\openai_batch\OpenAiBatchProcessorPluginManager;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Queue worker for processing a single item from an OpenAI Batch result.
 *
 * @QueueWorker(
 *   id = "openai_batch_process",
 *   title = @Translation("OpenAI Batch Process Queue Worker"),
 * )
 */
class OpenAiBatchProcessWorker extends QueueWorkerBase implements ContainerFactoryPluginInterface {

  /**
   * {@inheritdoc}
   */
  public function processItem($data) {
    $batch_id = $data['batch_id'];
    $custom_id = $data['custom_id'];
    $result_string = $data['result_string'];
    [, $entity_type_id, $entity_id] = explode('::', $custom_id);
    $openai_batch_request = $this->entityTypeManager->getStorage('openai_batch_request')->load($batch_id);
    $processor_id = $openai_batch_request->processor->value;
    $processor = $this->manager->createInstance($processor_id);
    $dummy_context = [];
    $processor::processResultItemOperation($openai_batch_request, $entity_type_id, $entity_id, $result_string, $dummy_context);
  }

  public function __construct(array $configuration, $plugin_id, array $plugin_definition, EntityTypeManagerInterface $entityTypeManager, OpenAiBatchProcessorPluginManager $openai_batch_processor_plugin_manager) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->entityTypeManager = $entityTypeManager;
    $this->manager = $openai_batch_processor_plugin_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager'),
      $container->get('plugin.manager.openai_batch_processor'),
    );
  }

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  private EntityTypeManagerInterface $entityTypeManager;

  /**
   * The OpenAI Batch processor plugin manager.
   *
   * @var \Drupal\openai_batch\OpenAiBatchProcessorPluginManager
   */
  private OpenAiBatchProcessorPluginManager $manager;

}
