<?php

namespace Drupal\openai_batch\DTO;

/**
 * Configuration DTO class for a single request item in a batch.
 */
class OpenAiBatchRequestItemConfig {

  public function __construct(
    public readonly string $model = "gpt-4o",
    public readonly string $url = "/v1/chat/completions",
    public readonly int $maxTokens = 4096,
    public readonly float $temperature = 0,
    public readonly float $frequencyPenalty = 0,
    public readonly float $presencePenalty = 0,
    public readonly float $topP = 1.0,
    public readonly string $systemPrompt = "",
    public readonly string $userPrompt = "",
  ) {}

}
