<?php

namespace Drupal\openai_batch;

use Drupal\openai_batch\DTO\OpenAiBatchRequestItemConfig;
use Drupal\openai_batch\Entity\OpenAiBatchRequest;

/**
 * Interface for openai_batch_processor plugins.
 */
interface OpenAiBatchProcessorInterface {

  /**
   * Returns the translated plugin label.
   */
  public function label(): string;

  /**
   * Get the command to send to OpenAI for a single entity.
   *
   * @param string $entity_type
   *   The entity type ID of the entity to process.
   * @param string $entity_id
   *   The entity ID of the entity to process.
   * @param \Drupal\openai_batch\DTO\OpenAiBatchRequestItemConfig $request_item_config
   *   The configuration for the request.
   * @param mixed $context
   *   Any additional context you want to add when you call the method manually.
   */
  public function getOpenAiBatchCommandForEntity(string $entity_type, string $entity_id, OpenAiBatchRequestItemConfig $request_item_config, mixed $context = NULL): array;

  /**
   * Drupal Batch API operation callback, to process a single item from an
   * OpenAI's Batch response.
   *
   * @param \Drupal\openai_batch\Entity\OpenAiBatchRequest $openai_batch_request
   *   The OpenAI Batch request entity.
   * @param string $entity_type_id
   *   The entity type ID for the entity that will be updated with the result.
   * @param string $entity_id
   *   The entity ID for the entity that will be updated with the result.
   * @param string $result_string
   *   The result string from OpenAI's Batch response.
   * @param array $context
   *   The batch context array.
   *
   * @return void
   *   The method does not return anything.
   */
  public static function processResultItemOperation(OpenAiBatchRequest $openai_batch_request, string $entity_type_id, string $entity_id, string $result_string, &$context): void;

}
