<?php

namespace Drupal\openai_batch;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\openai_batch\Attribute\OpenAiBatchProcessor;

/**
 * OpenAiBatchProcessor plugin manager.
 */
final class OpenAiBatchProcessorPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/OpenAiBatchProcessor', $namespaces, $module_handler, OpenAiBatchProcessorInterface::class, OpenAiBatchProcessor::class);
    $this->alterInfo('openai_batch_processor_info');
    $this->setCacheBackend($cache_backend, 'openai_batch_processor_plugins');
  }

}
