<?php

namespace Drupal\openai_batch\Plugin\Action;

use Drupal\ai\Plugin\ProviderProxy;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openai_batch\DTO\OpenAiBatchRequestItemConfig;

/**
 * Interface for OpenAI Batch VBO actions.
 */
interface OpenAiBatchVBOActionInterface {

  /**
   * Proxy method for the VBO preconfiguration form.
   *
   * @see \Drupal\views_bulk_operations\Action\ViewsBulkOperationsPreconfigurationInterface::buildPreConfigurationForm
   */
  public function buildPreConfigurationForm(array $element, array $values, FormStateInterface $form_state): array;

  /**
   * Proxy method for the end user configuration form.
   *
   * @see \Drupal\Core\Plugin\PluginFormInterface::buildConfigurationForm
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $vbo_context, ProviderProxy $llm_instance): array;

  /**
   * Proxy method for the configuration form validation.
   *
   * @see \Drupal\Core\Plugin\PluginFormInterface::validateConfigurationForm
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state): void;

}
