<?php

namespace Drupal\openai_batch\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Link;
use Drupal\Core\Url;

/**
 * Plugin implementation of the OpenAI Batch local jsonl file view link formatter.
 *
 * @FieldFormatter(
 *   id = "openai_batch_local_jsonl_file_view_link",
 *   label = @Translation("OpenAI Batch local jsonl file view link"),
 *   field_types = {"string"},
 * )
 */
final class LocalJsonlFileLinkFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public static function isApplicable(FieldDefinitionInterface $field_definition) {
    return $field_definition->getTargetEntityTypeId() === 'openai_batch_request' &&
      ($field_definition->getName() === 'input_file_id' || $field_definition->getName() === 'output_file_id');
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $field_name = $this->fieldDefinition->getName();
    $field_type = str_replace('_file_id', '', $field_name);
    $element = [];
    foreach ($items as $delta => $item) {
      $file_id = $item->value;
      $route = 'openai_batch.jsonl_file_content';
      $url = Url::fromRoute($route, [
        'openai_batch_request' => $items->getEntity()->id(),
        'file_type' => $field_type,
      ]);
      $link = Link::fromTextAndUrl($file_id, $url);
      $element[$delta] = $link->toRenderable();
    }
    return $element;
  }

}
