# Contributing to OpenCulturas

OpenCulturas is based on Drupal. Drupal core and the largest part of contributed modules/themes is developed on [Drupal.org](https://www.drupal.org).

Drupal.org hosts the official [GitLab repository of OpenCulturas](https://git.drupalcode.org/project/openculturas) and its [issue queue](https://www.drupal.org/project/issues/openculturas). The OpenCulturas [documentation can be found on OpenCulturas.org](https://www.openculturas.org/en/manual)

Before you start working on code, be sure to search the issue queue and create one if you aren't able to find a matching issue. Every issue on Drupal.org automatically creates a new community-accessible fork that you can contribute to.

Learn more about the code contribution process on [Drupal's issue forks & merge requests page](https://www.drupal.org/drupalorg/docs/gitlab-integration/issue-forks-merge-requests).

## Your contribution is very welcome

You do not need to be a developer to contribute to open source projects. It takes many skills to provide good software that helps people to fulfil their tasks:

- Add missing translations or enhance given ones
- Conduct usability tests and structure the findings (one issue per task)
- Describe any malfunction you notice in a reproducible way to help us fix the problem
- Describe a missing feature in a way that can be solved by an update
- Record a tutorial and publish it under a Creative Commons license (so we can cross-publish on openculturas.org and give you credits)
- Promote the software
- Support fundraising

When submitting code or comments, we expect contributors to follow [Drupal's Code of Conduct](https://www.drupal.org/dcoc) (or basically any free and open source community's CoC). In short: be respectful, be friendly, give people the benefit of the doubt ;-)

## Found a security issue?

See [SECURITY.md](SECURITY.md)</a>

## Development principles

See [DEVELOPMENT.md](DEVELOPMENT.md)</a>

## Questions? Let's talk!

We are aiming to have regular online consultation hours, open to everyone and free to everyone. Check the [upcoming dates](https://www.openculturas.org/en/dojo) and in case you do not find any, contact us.
