We are long-term proud members of the Drupal community. One reason to be proud of that is that security is taken seriously and handled responsibly. **Responsible Disclosure** is key.

## How to report a security vulnerability

When you find a vulnerability, follow these steps:

1. Address our security team in a non-public way (i. e. [report the issue on Drupal.org](https://www.drupal.org/project/openculturas/report-security-issue) or send us an encrypted email)
2. In case you feel uncertain about email encryption contact us _without any details_ first (i. e. "I found a security vulnerability, please give me a safe way to communicate details")
3. Assess category and severity, if possible—the [security risk calculator](https://www.drupal.org/drupal-security-team/security-risk-calculator) may help.
4. Note details how to reproduce the exploit (in theory)

### Email

Best contact us in English or German.

- OpenCulturas security team's email: [security@openculturas.org](mailto:security@openculturas.org)
- [Public key for encryption](https://files.openculturas.org/security/security@openculturas.org.asc)

### Do not

- By any means, for the sake of all OpenCulturas site owners an their registered users, **please keep your findings confidential**
- **Do not exploit** the vulnerability yourself. If you happen to gain access to, say, personal data, do not make a copy, do not take a screenshot. Simply note the steps a theoretical exploit would require
- Do **not brag publicly** about what you found. You will get credits in the course of publishing the security patch. Please give us your prefered user name and a public link to an account so we can properly attribute your contribution to safer software

### Alternative: report to the Drupal security team

In case you find a larger organization more trustworthy, feel free to report the discovered security vulnerability to [the Drupal security team](https://www.drupal.org/docs/develop/issues/issue-procedures-and-etiquette/reporting-a-security-issue).

## No bug bounty program, sorry

OpenCulturas development is underfunded. We are doing our best to keep the software secure and stable based on some maintenance contracts and a lot of personal commitment. Thank you for your understanding.

Please refrain from web scanning or AI-based code quality reports. We know how to use those tools, too.
