<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

use Drupal\field\Plugin\migrate\source\d7\Field;
use Drupal\field\Plugin\migrate\source\d7\FieldInstance;
use Drupal\field\Plugin\migrate\source\d7\ViewMode;
use Drupal\migrate_drupal\Plugin\migrate\FieldMigration;

/**
 * Alter Bean Types migrations.
 */
class BeanTypes extends MigrationPluginsAlters {

  /**
   * {@inheritDoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public static function alter(array &$migrations) {
    parent::alter($migrations);
    self::alterBeanType();
  }

  /**
   * Alter Bean Type Plugin.
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  protected static function alterBeanType() {
    $migrations = &self::$migrations;
    // Alter field migrations to include Bean.
    if (!isset($migrations['upgrade_d7_bean_type'])) {
      return;
    }

    /** @var \Drupal\migrate\Plugin\MigrationPluginManager $migration_plugin_manager */
    $migration_plugin_manager = \Drupal::service('plugin.manager.migration');
    foreach ($migrations as &$migration) {
      $migration_stub = $migration_plugin_manager->createStubMigration($migration);

      /** @var \Drupal\migrate\Plugin\MigrateSourcePluginManager $source_plugin_manager */
      $source_plugin_manager = \Drupal::service('plugin.manager.migrate.source');

      $configuration = $migration['source'];
      $source = $source_plugin_manager->createInstance($migration['source']['plugin'], $configuration, $migration_stub);
      if ($source) {
        if (is_a($migration['class'], FieldMigration::class, TRUE)) {

          // Field storage.
          if (is_a($source, Field::class)) {
            self::adjustBeanTypeType($migration);
          }

          // Field instance.
          if (is_a($source, FieldInstance::class)) {
            self::adjustBeanTypeType($migration);
            self::adjustBeanTypeBundle($migration);
            $migration['migration_dependencies']['optional']['d7_bean_type'] = 'd7_bean_type';
          }
        }

        // View Modes.
        if (is_a($source, ViewMode::class)) {
          self::adjustBeanTypeType($migration);
          self::adjustBeanTypeType($migration, 'targetEntityType');
        }
      }
    }

  }

  /**
   * Map bean fields to 'block_content'.
   *
   * @param array $migration
   *   Thei migration to process.
   * @param string $destination
   *   The process destination.
   */
  public static function adjustBeanTypeType(array &$migration, string $destination = 'entity_type') {
    $entity_type_process = $migration['process'][$destination] ?? false;

    if (!$entity_type_process) {
      return;
    }
    
    // Try to play with other modules altering this, and don't replace it
    // outright unless it's unchanged.
    if (!is_array($entity_type_process)) {
      $entity_type_process = [
        [
          'plugin' => 'get',
          'source' => 'entity_type',
        ],
      ];
    }

    $entity_type_process['bean'] = [
      'plugin' => 'static_map',
      'map' => [
        'bean' => 'block_content',
      ],
      'bypass' => TRUE,
    ];

    $migration['process'][$destination] = $entity_type_process;
  }

  /**
   * Remove 'field_' prefix from bean bundles.
   *
   * @param array $migration
   *   The migration configuration to process.
   */
  public static function adjustBeanTypeBundle(array &$migration) {
    if (!isset($migration['process']['bundle'])) {
      $migration['process']['bundle'] = [];
    }

    $bundle_process = $migration['process']['bundle'];

    // Try to play nice with other modules altering this, and don't replace
    // it outright unless it's unchanged.
    if (array_key_exists('plugin', $bundle_process)) {
      $bundle_process = [$bundle_process];
    }
    // $bundle_process['paragraphs'] = [
    //      'plugin' => 'paragraphs_process_on_value',
    //      'source_value' => 'entity_type',
    //      'expected_value' => 'field_collection_item',
    //      'process' => [
    //        'plugin' => 'substr',
    //        'start' => Bean::BEAN_PREFIX_LENGTH,
    //      ],
    //    ];
    $migration['process']['bundle'] = $bundle_process;
  }

}
