<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 * Alter Blocks migrations plugins.
 */
class Blocks extends MigrationPluginsAlters {

  /**
   * {@inheritDoc}
   */
  public static function alter(array &$migrations) {
    parent::alter($migrations);

    self::alterBlock();
  }

  /**
   * Alter Block Migration Plugin.
   */
  protected static function alterBlock() {
    $migrations = &self::$migrations;
    if (!isset($migrations['d7_block'])) {
      return;
    }
    /*
     * Blocks migration should depend on Menus and
     *   Menu links in order to import menu_blocks.
     */
    $migrations['d7_block']['migration_dependencies']['required'][] = 'd7_menu';
    $migrations['d7_block']['migration_dependencies']['required'][] = 'd7_menu_links';
    $migrations['d7_block']['migration_dependencies']['required'][] = 'd7_menu_link_items';

    /*
     * By changing block id concatenation, removing the "theme" name part
     *   (which we don't need since we care only about frontend theme)
     *   we are able to keep some old block classes.
     */
    $migrations['d7_block']['process']['id'][0]['source'] = ['module', 'delta'];

    /*
     * We need to migrate language and content type visibility settings,
     *   since no module is taking care of it...
     */
    $migrations['d7_block']['process']['visibility']['source'][] = 'language';
    $migrations['d7_block']['process']['visibility']['source'][] = 'content_type';

    /*
     * Avoid blocks with status = false to be skipped.
     * They may be useful in the future.
     */
    $migrations['d7_block']['process']['status'] = 'status';
  }

}
