<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 *
 */
class FieldCollectionTypes {

  /**
   * Alter field_collection_type migration plugin settings.
   *
   * @param array $migrations
   *   An array of migration plugin configurations.
   */
  public static function alter(array &$migrations) {
    /*
     * Some fields, like field collections, seem to require that file already
     *   exist.
     * As such we will make file migration a requirement for field creation.
     */
    if (isset($migrations['d7_field_collection_type'])) {
      $migrations['d7_field_collection_type']['migration_dependencies']['required'][] = 'd7_file';
    }
  }

}
