<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 *
 */
class Fields extends MigrationPluginsAlters {

  /**
   * {@inheritDoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public static function alter(array &$migrations) {
    parent::alter($migrations);

    self::alterFieldInstance();
  }

  /**
   * Alter field migrations to include Bean.
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  protected static function alterFieldInstance() {
    $migrations = &self::$migrations;
    // Alter field migrations to include Bean.
    if (!isset($migrations['d7_field_instance'])) {
      return;
    }

    $bean_reference_fields = self::getBeanReferenceFields();

    if (!empty($bean_reference_fields)) {
      self::processBeanReferenceFields($bean_reference_fields);
    }

    /*
     * To assure the correct migration of default image,
     *   we must migrate files first.
     */
    self::$migrations['d7_field_instance']['migration_dependencies']['required'][] = 'd7_file';

  }

  /**
   * Get bean reference fields from the source.
   *
   * @return array
   *   An array of bean reference fields.
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public static function getBeanReferenceFields(): array {
    $migration = self::$migrations['d7_field_instance'];

    $bean_reference_fields = [];

    $migration_stub = \Drupal::service('plugin.manager.migration')
      ->createStubMigration($migration);

    /** @var \Drupal\migrate\Plugin\MigrateSourcePluginManager $source_plugin_manager */
    $source = \Drupal::service('plugin.manager.migrate.source')
      ->createInstance($migration['source']['plugin'], $migration['source'], $migration_stub);
    if ($source) {
      foreach ($source as $row) {
        $field_data = $row->getSource();
        if ($field_data['type'] == 'entityreference') {
          $field_definition = unserialize($field_data['field_definition']['data']);
          $settings = $field_definition['settings'];
          if ($settings['target_type'] == 'bean') {
            $bean_reference_fields[$row->getSourceProperty('field_name')] = $row->getSourceProperty('field_name');
          }
        }
      }
    }
    return $bean_reference_fields;
  }

  /**
   * Process bean reference fields and alter their migrations.
   *
   * @param array $bean_reference_fields
   *   An array of bean reference field names.
   */
  protected static function processBeanReferenceFields(array $bean_reference_fields) {

    foreach ($bean_reference_fields as $field_name) {
      foreach (self::$migrations as &$migration) {
        // Check for processes and alter them.
        if (isset($migration['process'][$field_name]) && $migration['process'][$field_name]['plugin'] == 'get') {
          $migration['process'][$field_name] = [
            'plugin' => 'sub_process',
            'source' => $field_name,
            'process' => [
              'target_id' => [
                'plugin' => 'migration_lookup',
                'migration' => 'd7_bean',
                'source' => 'target_id',
              ],
            ],
          ];
        }
      }
    }
  }

}
