<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

use Drupal\openfed_migrate\Helper;

/**
 * Alter Files migrations plugins.
 */
class Files extends MigrationPluginsAlters {

  /**
   * {@inheritDoc}
   */
  public static function alter(array &$migrations) {
    parent::alter($migrations);

    self::alterFile();
    self::alterFilePrivate();
  }

  /**
   * Public file migration updates.
   */
  protected static function alterFile() {
    $migrations = &self::$migrations;
    if (!isset($migrations['d7_file'])) {
      return;
    }

    // We need to change the process plugin to add a skip row if the uri is
    // invalid (like in the case of a missing file in the source).
    if (isset($migrations['d7_file']['process']['uri']['plugin'])) {
      $new_file_uri = $migrations['d7_file']['process']['uri'];
      $migrations['d7_file']['process']['uri'] = [];
      $migrations['d7_file']['process']['uri'][] = $new_file_uri;
    }
    $migrations['d7_file']['process']['uri'][] = [
      'plugin' => 'skip_on_empty',
      'method' => 'row',
    ];

    // We must add file fields to file migration (since it uses file_entity).
    // We also add a type to allow a correct field migration.
    $bundles = \Drupal::service('entity_type.bundle.info')
      ->getBundleInfo('file');
    foreach ($bundles as $bundle => $bundle_info) {
      $fields = Helper::getFields('file', $bundle);
      foreach ($fields as $field_name => $field) {
        // We add a mapping here for the old/new field names.
        $mapping = [
          'field_file_image_alt_text' => 'field_image_alt_text',
          'field_file_image_title_text' => 'field_image_title_text',
        ];
        $field_name_new = $mapping[$field_name] ?? $field_name;
        $migrations['d7_file']['process'][$field_name_new] = $field_name;
      }
    }
    $migrations['d7_file']['process']['type'] = 'type';

  }

  /**
   * Private file migration updates.
   */
  protected static function alterFilePrivate() {
    $migrations = &self::$migrations;
    if (!isset($migrations['d7_file_private'])) {
      return;
    }

    // We must add file fields to file migration (since it uses file_entity).
    // We also add a type to allow a correct field migration.
    $bundles = \Drupal::service('entity_type.bundle.info')
      ->getBundleInfo('file');
    foreach ($bundles as $bundle => $bundle_info) {
      $fields = Helper::getFields('file', $bundle);
      foreach ($fields as $field_name => $field) {
        // We add a mapping here for the old/new field names.
        $mapping = [
          'field_file_image_alt_text' => 'field_image_alt_text',
          'field_file_image_title_text' => 'field_image_title_text',
        ];
        $field_name_new = $mapping[$field_name] ?? $field_name;
        $migrations['d7_file_private']['process'][$field_name_new] = $field_name;
      }
    }
    $migrations['d7_file_private']['process']['type'] = 'type';

  }

}
