<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 * Alter focal_point migrations plugins.
 */
class FocalPoints extends MigrationPluginsAlters {

  /**
   * {@inheritDoc}
   */
  public static function alter(array &$migrations) {
    parent::alter($migrations);

    /*
     * If focal_point is disabled, we cannot import to crop entity
     *   and as such the migration should be disabled.
     */
    if (!self::$moduleHandler->moduleExists('focal_point')) {
      unset($migrations['d7_focal_point']);
    }
    else {
      // If enabled, we set the correct destination.
      // Temporary solution until focal_point does not have a migration path
      // included.
      $migrations['d7_focal_point']['destination']['plugin'] = 'entity:crop';
    }
  }

}
