<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 * Alter Menu migrations plugins.
 */
class Menus extends MigrationPluginsAlters {

  /**
   * {@inheritDoc}
   */
  public static function alter(array &$migrations) {
    parent::alter($migrations);

    self::alterMenuLinks();
    self::alterMenu();
  }

  /**
   * Alter Menu Links.
   *
   * We need to import menu_link field items before importing menu items.
   * We will then override d7_menu_links in order to exclude already migrated
   *   items on d7_menu_link_items. Like this we avoid duplicated menu items.
   */
  protected static function alterMenuLinks() {
    $migrations = &self::$migrations;

    if (!isset($migrations['d7_menu_links'])) {
      return;
    }

    // We also change the process plugin to add a skip row if the uri is
    // invalid.
    if (isset($migrations['d7_menu_links']['process']['link/uri']['plugin'])) {
      $new_link_uri = $migrations['d7_menu_links']['process']['link/uri'];
      $migrations['d7_menu_links']['process']['link/uri'] = [];
      $migrations['d7_menu_links']['process']['link/uri'][] = $new_link_uri;
    }
    $migrations['d7_menu_links']['process']['link/uri'][] = [
      'plugin' => 'skip_on_empty',
      'method' => 'row',
    ];

  }

  /**
   * Alter Menus.
   *
   * We will try to guess the menu language based on menu title. In D7 menus
   * used to have the language in its title. If not correctly migrated, this
   * must be changed after migration to assure a correct breadcrumb.
   */
  protected static function alterMenu() {
    if (isset(self::$migrations['d7_menu'])) {
      self::$migrations['d7_menu']['process']['langcode'] = 'langcode';
    }
  }

}
