<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 * Abstract class that can be used as base for migration plugin alters.
 */
abstract class MigrationPluginsAlters {

  /**
   * List of Migrations.
   *
   * @var array
   */
  static protected $migrations = [];

  /**
   * Module Handler.
   *
   * @var \Drupal\Core\Extension\ModuleHandlerInterface
   */
  static protected $moduleHandler;

  /**
   * Alter a migration plugin settings.
   *
   * @param array $migrations
   *   An array of migration plugin configurations.
   */
  public static function alter(array &$migrations) {
    self::$migrations = &$migrations;
    self::$moduleHandler = \Drupal::service('module_handler');
  }

  /**
   * Filter Migrations plugins based on a Migration Name.
   *
   * @param string $migrationName
   *   Name of the migration that we need to filter on.
   *
   * @return array
   *   Filtered array of migration plugin configuration.
   */
  protected static function filterMigrations(string $migrationName): array {
    return array_filter(self::$migrations, function ($key) use ($migrationName) {
      return strpos($key, $migrationName) !== FALSE;
    }, ARRAY_FILTER_USE_KEY);
  }

}
