<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

use Drupal\openfed_migrate\Helper;

/**
 * Alter nodes migrations plugins.
 */
class Nodes extends MigrationPluginsAlters {

  /**
   * Alters the migrations array to handle node and node translation migrations.
   *
   * {@inheritDoc}
   */
  public static function alter(array &$migrations) {
    parent::alter($migrations);

    self::alterNode();
    self::alterNodeTranslation();
  }

  /**
   * Alter nodes migration plugins.
   */
  public static function alterNode() {
    $migrations = &self::$migrations;

    $node_migrations = self::filterMigrations('d7_node:');
    $long_text_fields = Helper::getLongTextFields();
    foreach (array_keys($node_migrations) as $node_migration) {
      // Nodes should depend on weight if module enabled.
      if (self::$moduleHandler->moduleExists('weight')) {
        $migrations[$node_migration]['migration_dependencies']['required'][] = 'd7_weight_field_instance';
      }

      /*
       * We parse longtext fields using plugin,
       *   which actually uses custom OpenfedDom.
       */
      foreach ($long_text_fields as $long_text_field => $value) {
        if (isset($migrations[$node_migration]['process'][$long_text_field])) {
          unset($migrations[$node_migration]['process'][$long_text_field]);
          $migrations[$node_migration]['process'][$long_text_field . '/value'] = [
            [
              'plugin' => 'dom',
              'method' => 'import',
              'source' => $long_text_field . '/0/value',
            ],
            [
              'plugin' => 'dom',
              'method' => 'export',
            ],
          ];
          $migrations[$node_migration]['process'][$long_text_field . '/format'] = [
            'plugin' => 'get',
            'source' => $long_text_field . '/0/format',
          ];
          $migrations[$node_migration]['process'][$long_text_field . '/summary'] = [
            'plugin' => 'get',
            'source' => $long_text_field . '/0/summary',
          ];
        }
      }
    }
  }

  /**
   * Alter nodes translations migrations.
   */
  public static function alterNodeTranslation() {
    $migrations = &self::$migrations;
    $long_text_fields = Helper::getLongTextFields();
    $node_translation_migrations = self::filterMigrations('d7_node_translation:');

    foreach (array_keys($node_translation_migrations) as $node_translation_migration) {
      /*
       * We check for taxonomy term ids in long text fields.
       * The problem is that the migration cannot create aliases
       * for old term ID's and some nodes have hardcoded links
       * to these old term ID's, so we need to map them to real
       * migrated term translations.
       */
      foreach ($long_text_fields as $long_text_field => $value) {
        if (isset($migrations[$node_translation_migration]['process'][$long_text_field])) {
          unset($migrations[$node_translation_migration]['process'][$long_text_field]);
          $migrations[$node_translation_migration]['process'][$long_text_field . '/value'] = [
            [
              'plugin' => 'dom',
              'method' => 'import',
              'source' => $long_text_field . '/0/value',
            ],
            [
              'plugin' => 'dom_migration_lookup',
              'mode' => 'attribute',
              'xpath' => '//a',
              'attribute_options' => [
                'name' => 'href',
              ],
              'search' => '@/taxonomy/term/(\d+)@',
              'replace' => '/taxonomy/term/[mapped-id]',
              'migrations' => [
                'upgrade_d7_taxonomy_term_translation' => [
                  'replace' => '/taxonomy/term/[mapped-id]',
                ],
              ],
            ],
            [
              'plugin' => 'dom',
              'method' => 'export',
            ],
          ];

          $migrations[$node_translation_migration]['process'][$long_text_field . '/format'] = [
            'plugin' => 'get',
            'source' => $long_text_field . '/0/format',
          ];

          $migrations[$node_translation_migration]['process'][$long_text_field . '/summary'] = [
            'plugin' => 'get',
            'source' => $long_text_field . '/0/summary',
          ];
        }
      }
    }
  }

}
