<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

use Drupal\openfed_migrate\Helper;

/**
 * Alter Taxonomy Terms related Migrations plugins.
 */
class TaxonomyTerms extends MigrationPluginsAlters {

  /**
   * {@inheritDoc}
   */
  public static function alter(array &$migrations) {
    parent::alter($migrations);
    self::alterTaxonomyTermTranslation();
    self::alterTaxonomyTermFinalFixes();
    self::alterTaxonomyTerm();
    self::alterTaxonomyTermEntityTranslation();

    /*
     * Change source plugin id of d7_term_localized_translation migration
     *   with our custom openfed_d7_term_localized_translation.
     */
    if (isset($migrations['d7_taxonomy_term_localized_translation'])) {
      $migrations['d7_taxonomy_term_localized_translation']['source']['plugin'] = 'openfed_d7_term_localized_translation';
    }

    /*
     * We are changing this map in core due to the above taxonomy
     *   term translation procedure.
     * Current use cases show us that taxonomy translations should be
     *   handled differently...
     */
    if (isset($migrations['d7_language_content_taxonomy_vocabulary_settings'])) {
      $migrations['d7_language_content_taxonomy_vocabulary_settings']['process']['third_party_settings/content_translation/enabled']['map']['4'] = TRUE;
    }
  }

  /**
   * Filter Taxonomy Term Entity Translations Migrations plugins.
   */
  public static function alterTaxonomyTermTranslation() {
    $migrations = &self::$migrations;
    // We need to alter the term translation according to the query on
    // OpenfedTermTranslation source.
    if (isset($migrations['d7_taxonomy_term_translation'])) {
      return;
    }

    /*
     * We unset the parent fields.
     * Parents will be handled on taxonomy final fixes.
     */
    unset($migrations['d7_taxonomy_term_translation']['process']['parent_id']);
    unset($migrations['d7_taxonomy_term_translation']['process']['parent']);

    // Alter process properties according to OpenfedTermTranslation source.
    $migrations['d7_taxonomy_term_translation']['process']['tid'] = 'ttid';
    $migrations['d7_taxonomy_term_translation']['destination']['translations'] = TRUE;

    // Set description text format.
    $migrations['d7_taxonomy_term_translation']['process']['description/format'] = [
      'plugin' => 'default_value',
      'default_value' => 'flexible_html',
    ];

    /*
     * We add a dependency to menu links because some menus may point to
     *   taxonomy terms (view with arguments).
     */
    if (isset($migrations['d7_menu_links'])) {
      $migrations['d7_menu_links']['migration_dependencies']['required'][] = 'd7_taxonomy_term_translation';
    }
  }

  /**
   * Alter Taxonomy Term Final Mix Migrations Plugins.
   */
  protected static function alterTaxonomyTermFinalFixes() {
    $migrations = &self::$migrations;

    /*
     * Translatable vocabularies with fields should have its content fixed with
     *   final fixes where translated values will be migrated.
     */
    $taxonomy_term_migrations = self::filterMigrations('d7_taxonomy_term_final_fixes:');

    foreach (array_keys($taxonomy_term_migrations) as $taxonomy_term_migration) {
      $translatableFields = Helper::getTaxonomyTranslatableFields($taxonomy_term_migrations[$taxonomy_term_migration]['source']['bundle']);
      if (!empty($translatableFields)) {
        $overwrite_properties = $migrations[$taxonomy_term_migration]['destination']['overwrite_properties'];
        $migrations[$taxonomy_term_migration]['destination']['overwrite_properties'] = array_merge($overwrite_properties, $translatableFields);
        $migrations[$taxonomy_term_migration]['destination']['translations'] = TRUE;
      }
    }
  }

  /**
   * Alter taxonomy term migrations plugin.
   */
  protected static function alterTaxonomyTerm() {
    $migrations = &self::$migrations;

    /*
     * We unset the parent fields.
     * Parents will be handled on taxonomy final fixes.
     */
    $taxonomy_term_migrations = self::filterMigrations('d7_taxonomy_term:');
    foreach (array_keys($taxonomy_term_migrations) as $taxonomy_term_migration) {
      unset($migrations[$taxonomy_term_migration]['process']['parent_id']);
      unset($migrations[$taxonomy_term_migration]['process']['parent']);

      // Set description text format.
      $migrations[$taxonomy_term_migration]['process']['description/format'] = [
        'plugin' => 'default_value',
        'default_value' => 'flexible_html',
      ];
    }
  }

  /**
   * Alter Taxonomy Term Migrations plugins.
   */
  protected static function alterTaxonomyTermEntityTranslation() {
    // Code to run on all term entity translation derivatives.
    $taxonomy_term_migrations = self::filterMigrations('d7_taxonomy_term_entity_translation:');
    foreach (array_keys($taxonomy_term_migrations) as $taxonomy_term_migration) {
      // Set description text format.
      self::$migrations[$taxonomy_term_migration]['process']['description/format'] = [
        'plugin' => 'default_value',
        'default_value' => 'flexible_html',
      ];
    }
  }

}
