<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 * Alter themes migrations plugins.
 */
class ThemeSettings {

  /**
   * Alter theme migration plugin settings.
   *
   * @param array $migrations
   *   An array of migration plugin configurations.
   */
  public static function alter(array &$migrations) {
    // Several of our themes use underscores in their name. d7_theme_settings
    // migration process gets the old theme name in a wrong way so we need to
    // override that process. Old theme settings are obtain from the variable
    // theme_%_settings, where % is a wildcard with the theme name we want.
    $migrations['d7_theme_settings']['process']['theme_name'] = [
      "plugin" => 'str_replace',
      "regex" => 'true',
      "source" => 'name',
      "search" => '/(^theme_)|(_settings)+$/',
      "replace" => '',
    ];
  }

}
