<?php

namespace Drupal\openfed_migrate\Plugin\migrate\field;

use Drupal\migrate\Plugin\MigrationInterface;
use Drupal\migrate_drupal\Plugin\migrate\field\FieldPluginBase;

/**
 * Field Plugin for bean migrations.
 *
 * @MigrateField(
 *   id = "bean",
 *   core = {7},
 *   type_map = {
 *     "bean" = "block_content",
 *   },
 *   source_module = "bean",
 *   destination_module = "block_content",
 * )
 */
class Bean extends FieldPluginBase {

  /*
   * Length of the 'field_' prefix that field collection prepends to bundles.
   */
  const BEAN_PREFIX_LENGTH = 6;

  /**
   * {@inheritdoc}
   */
  public function processFieldValues(MigrationInterface $migration, $field_name, $data) {
    $this->defineValueProcessPipeline($migration, $field_name, $data);
  }

  /**
   * {@inheritdoc}
   */
  public function defineValueProcessPipeline(MigrationInterface $migration, $field_name, $data) {
    $process = [
      'plugin' => 'sub_process',
      'source' => $field_name,
      'process' => [
        'target_id' => [
          [
            'plugin' => 'entity_lookup',
            'tags' => 'Bean Content',
            'source' => 'value',
          ],
          [
            'plugin' => 'extract',
            'index' => ['id'],
          ],
        ],
        //        'target_revision_id' => [
        //          [
        //            'plugin' => 'paragraphs_lookup',
        //            'tags' => [
        //              'Field Collection Revisions Content',
        //              'Field Collection Content',
        //            ],
        //            'tag_ids' => [
        //              'Field Collection Revisions Content' => ['revision_id'],
        //              'Field Collection Content' => ['value'],
        //            ],
        //          ],
        //          [
        //            'plugin' => 'extract',
        //            'index' => ['revision_id'],
        //          ],
        //        ],
      ],
    ];
    $migration->setProcessOfProperty($field_name, $process);

    // Add the respective bean migration as a dependency.
    $dependencies = $migration->getMigrationDependencies();
    $migration_dependency = 'd7_bean:' . substr($field_name, static::BEAN_PREFIX_LENGTH);
    $dependencies['required'][] = $migration_dependency;
    $migration->set('migration_dependencies', $dependencies);
  }

  /**
   * {@inheritdoc}
   */
  public function alterFieldFormatterMigration(MigrationInterface $migration) {
    $this->addViewModeProcess($migration);
    parent::alterFieldFormatterMigration($migration);
  }

  /**
   * Adds process for view mode settings.
   *
   * @param \Drupal\migrate\Plugin\MigrationInterface $migration
   *   The migration.
   */
  protected function addViewModeProcess(MigrationInterface $migration) {
    //    $view_mode = [
    //      'field_collection' => [
    //        'plugin' => 'paragraphs_process_on_value',
    //        'source_value' => 'type',
    //        'expected_value' => 'field_collection',
    //        'process' => [
    //          'plugin' => 'get',
    //          'source' => 'formatter/settings/view_mode',
    //        ],
    //      ],
    //    ];
    //    $migration->mergeProcessOfProperty('options/settings/view_mode', $view_mode);
  }

  /**
   * {@inheritdoc}
   */
  public function getFieldFormatterMap() {
    //    return [
    //        'field_collection_view' => 'entity_reference_revisions_entity_view',
    //        // TODO: Change the autogenerated stub.
    //      ] + parent::getFieldFormatterMap();
    return parent::getFieldFormatterMap();
  }

  /**
   * {@inheritdoc}
   */
  public function getFieldWidgetMap() {
    //    return ['field_collection_embed' => 'entity_reference_paragraphs']
    //      + parent::getFieldWidgetMap();
    return parent::getFieldWidgetMap();
  }

  /**
   * {@inheritdoc}
   */
  public function processField(MigrationInterface $migration) {
    $this->alterFieldMigration($migration);
  }

  /**
   * {@inheritdoc}
   */
  public function alterFieldMigration(MigrationInterface $migration) {
    $settings = [
      'bean' => [
        'plugin' => 'bean_field_settings',
      ],
    ];
    $migration->mergeProcessOfProperty('settings', $settings);
  }

  /**
   * {@inheritdoc}
   */
  public function processFieldInstance(MigrationInterface $migration) {
    $this->alterFieldInstanceMigration($migration);
  }

  /**
   * {@inheritdoc}
   */
  public function alterFieldInstanceMigration(MigrationInterface $migration) {
    //    $settings = [
    //      'field_collection' => [
    //        'plugin' => 'field_collection_field_instance_settings',
    //      ],
    //    ];
    //    $migration->mergeProcessOfProperty('settings', $settings);

    return parent::alterFieldInstanceMigration($migration);
  }

  public function alterFieldWidgetMigration(MigrationInterface $migration) {
    return parent::alterFieldWidgetMigration($migration);
  }

}
