<?php

namespace Drupal\openfed_migrate\Plugin\migrate\source\bean;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\State\StateInterface;
use Drupal\migrate\Plugin\MigrationInterface;
use Drupal\migrate\Row;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Drupal 7 bean entity source from database.
 *
 * @MigrateSource(
 *   id = "d7_bean_type",
 *   source_module = "bean"
 * )
 */
class BeanType extends DrupalBeanSqlBase {

  /**
   * The module handler.
   *
   * @var \Drupal\Core\Extension\ModuleHandlerInterface
   */
  protected $moduleHandler;

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, MigrationInterface $migration, StateInterface $state, EntityTypeManagerInterface $entity_manager, ModuleHandlerInterface $module_handler) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $migration, $state, $entity_manager);
    $this->moduleHandler = $module_handler;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition, MigrationInterface $migration = NULL) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $migration,
      $container->get('state'),
      $container->get('entity_type.manager'),
      $container->get('module_handler')
    );
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Exception
   */
  public function prepareRow(Row $row): bool {
    if (empty($row->getSourceProperty('label'))) {
      $row->setSourceProperty('label', ucfirst(str_replace('_', ' ', $row->getSourceProperty('name'))));
    }
    // @todo Change the autogenerated stub
    return parent::prepareRow($row);
  }

  /**
   * {@inheritdoc}
   */
  public function fields(): array {
    return [
      'name' => $this->t('The bean type identifier'),
      'label' => $this->t('The bean type readable name'),
      'description' => $this->t('Bean type description.'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getIds(): array {
    $ids['name']['type'] = 'string';
    return $ids;
  }

}
