<?php

namespace Drupal\openfed_migrate\Plugin\migrate\source\bean;

use Drupal\Core\Database\Query\SelectInterface;
use Drupal\migrate_drupal\Plugin\migrate\source\DrupalSqlBase;

/**
 *
 */
abstract class DrupalBeanSqlBase extends DrupalSqlBase {

  /**
   * {@inheritdoc}
   */
  public function query(): SelectInterface {
    // This query will allow us to avoid migrating beans without content which
    // usually means that this bean type is corrupt (probably due to features in
    // Drupal 7).
    $query = $this->select('bean', 'b');
    $query->leftJoin('bean_type', 'bt', 'bt.name = b.type');
    $query->addField('bt', 'label');
    $query->addField('bt', 'description');
    $query->addField('b', 'type', 'name');
    $query->groupBy('bt.label');
    $query->groupBy('bt.description');
    $query->groupBy('b.type');

    return $query;
  }

}
