<?php

namespace Drupal\openfed_migrate\Plugin\migrate\process\menu_link_content;

use Drupal\migrate\MigrateExecutableInterface;
use Drupal\migrate\ProcessPluginBase;
use Drupal\migrate\Row;

/**
 * @MigrateProcessPlugin(
 *   id = "menu_link_id_to_plugin_id"
 * )
 */
class MenuLinkIdToPluginId extends ProcessPluginBase  {

  /**
   * {@inheritdoc}
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    if (!is_array($value) || count($value) < 2) {
      return NULL;
    }

    list($mlid, $menu_name) = $value;

    if (!is_numeric($mlid) || !is_string($menu_name)) {
      return NULL;
    }

    // Load the link plugin ID from the menu tree.
    $menu_link = \Drupal::database()->select('menu_tree', 'mt')
      ->fields('mt', ['id'])
      ->condition('mt.mlid', $mlid)
      ->condition('mt.menu_name', $menu_name)
      ->execute()
      ->fetchAll();

    if (!empty($menu_link)) {
      return reset($menu_link)->id;
    }

    return NULL;
  }

}
