<?php

namespace Drupal\openfed_migrate\Plugin\migrate\source\menu_to_taxonomy;

use Drupal\migrate_drupal\Plugin\migrate\source\DrupalSqlBase;


/**
 * Drupal 7 menu to taxonomy sync items from database.
 *
 * @MigrateSource(
 *   id = "d7_menu_to_taxonomy_sync_items",
 *   source_module = "menu_to_taxonomy"
 * )
 */
class MenuToTaxonomySyncItems extends DrupalSqlBase {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $query = $this->select('menu_to_taxonomy', 'mt');
    $query->fields('mt', ['tid', 'vid', 'mlid']);
    $query->innerJoin('menu_links', 'ml', 'ml.mlid = mt.mlid');
    $query->addField('ml', 'menu_name');
    return $query;
  }

  /**
   * {@inheritdoc}
   */
  public function fields() {
    return [
      'tid' => $this->t('The taxonomy term ID.'),
      'vid' => $this->t('The vocabulary ID.'),
      'mlid' => $this->t('The menu link ID.'),
      'menu_name' => $this->t('The menu machine name.'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getIds() {
    return [
      'tid' => [
        'type' => 'integer',
      ],
    ];
  }

}
