<?php

namespace Drupal\openfed_migrate\Plugin\migrate\source\taxonomy;

use Drupal\migrate\Row;
use Drupal\migrate_drupal\Plugin\migrate\source\d7\FieldableEntity;

/**
 * Taxonomy term source from database.
 *
 * @MigrateSource(
 *   id = "d7_taxonomy_term_final_fixes_non_localized",
 *   source_module = "taxonomy"
 * )
 */
class OpenfedTermFinalFixesNonLocalized extends OpenfedTermNonLocalized {

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row) {
    parent::prepareRow($row);
    $parent = $row->getSourceProperty('parent');
    $row->setSourceProperty('parent', $parent[0]);
    return FieldableEntity::prepareRow($row);
  }
}
