<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 * Alter Custo Blocks Migrations plugins.
 */
class CustomBlocks {

  /**
   * Alter custom_blocks migrations plugin settings.
   *
   * @param array $migrations
   *   An array of migration plugin configurations.
   */
  public static function alter(array &$migrations) {
    // No need to do a migration_lookup for the format.
    if (isset($migrations['d7_custom_block'])) {
      $migrations['d7_custom_block']['process']['body/format'] = 'format';
    }

    if (isset($migrations['d7_custom_block_translation'])) {
      $migrations['d7_custom_block_translation']['process']['body/format'] = 'format';
    }
  }

}
