<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 * Class to alter Nodes types.
 */
class NodeTypes extends MigrationPluginsAlters {

  /**
   * {@inheritDoc}
   */
  public static function alter(array &$migrations) {

    // Fields should be imported before migrating node types. This is required
    // otherwise, when creating default fields like body, an error is thrown.
    if (isset($migrations['d7_node_type'])) {
      $migrations['d7_node_type']['migration_dependencies']['required'][] = 'd7_field';
    }

    if (isset($migrations['d7_node_type']) && self::$moduleHandler->moduleExists('weight')) {
      $migrations['d7_node_type']['migration_dependencies']['required'][] = 'd7_weight_field';
    }
  }

}
