<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 * Alter paths redirect migrations plugins.
 */
class PathRedirects {

  /**
   * Alter redirects migration plugin settings.
   *
   * @param array $migrations
   *   An array of migration plugin configurations.
   */
  public static function alter(array &$migrations) {

    // Replaces d7_path_redirect source plugin with our
    // custom in order to fix the default value for the
    // redirect status code.
    if (isset($migrations['d7_path_redirect'])) {
      $migrations['d7_path_redirect']['source']['plugin'] = 'openfed_d7_path_redirect';
    }
  }

}
