<?php

namespace Drupal\openfed_migrate\MigrationPluginsAlters;

/**
 *
 */
class Users extends MigrationPluginsAlters {

  /**
   * {@inheritDoc}
   */
  public static function alter(array &$migrations) {
    parent::alter($migrations);

    self::alterUserRole();
  }

  /**
   * Alter d7_user_role migration plugin.
   *
   * Add an extra process to user role names
   *   to map them into Openfed8 existing roles.
   * Do the same for permissions.
   * This may be need to be adjusted per project.
   */
  protected static function alterUserRole() {
    $migrations = &self::$migrations;
    if (!isset($migrations['d7_user_role'])) {
      return;
    }

    /*
     * In Openfed7 there was a Content Manager role which we'll try to
     *   map to Content Editor in Openfed8.
     */
    $migrations['d7_user_role']['process']['id'][] = ['plugin' => 'openfed_role_mapping'];
    // We also map the label, to keep the same name.
    $migrations['d7_user_role']['process']['label'] = [
      [
        'plugin' => 'get',
        'source' => 'name',
      ],
      [
        'plugin' => 'static_map',
        'bypass' => TRUE,
        'map' => [
          'Content Manager' => 'Content Editor',
        ],
      ],
    ];

    $migrations['d7_user_role']['process']['permissions'][0]['map'] += [
      'access administration menu' => 'access toolbar',
      'translate content' => 'translate any entity',
      'admin_display_suite' => 'admin display suite',
      'admin_fields' => 'admin fields',
      'admin_classes' => 'admin classes',
      'use text format full_html' => 'use text format flexible_html',
      'use text format filtered_html' => 'use text format embeddable_text',
      'view revisions' => 'view all revisions',
      'revert revisions' => 'revert all revisions',
      'delete revisions' => 'delete all revisions',
      'assign Builder role' => 'assign builder role',
      'assign Configurator role' => 'assign configurator role',
      'assign Content Manager role' => 'assign content_editor role',
      'assign User Manager role' => 'assign user_manager role',
    ];

  }

}
