<?php

namespace Drupal\openfed_migrate\Plugin\migrate\source\bean;

/**
 * Drupal 7 Bean Translation settings.
 *
 * All beans should be translatable in Drupal 8 installations.
 *
 * @MigrateSource(
 *   id = "d7_bean_translation_settings",
 *   source_module = "bean"
 * )
 */
class BeanTranslationSettings extends DrupalBeanSqlBase {

  /**
   * {@inheritdoc}
   */
  public function fields() {
    return [
      'name' => $this->t('The bean ID'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getIds() {
    $ids['name']['type'] = 'string';
    return $ids;
  }

}
