<?php

namespace Drupal\openfed_migrate\Plugin\migrate\source\field;

use Drupal\openfed_migrate\Helper;

/**
 *
 */
trait OpenfedFieldTrait {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $query = parent::query();

    // This fixes some issues that occur when comment module is disabled but
    // fields exist in Openfed 7 table (possibly due to features).
    if (!$this->moduleExists('comment')) {
      $query->condition('fci.entity_type', 'comment', 'NOT IN');
    }

    // This fixes some issues that occur when bean module is disabled but
    // fields exist in Openfed 7 table.
    if (!$this->moduleExists('bean')) {
      $query->condition('fci.entity_type', 'bean', 'NOT IN');
    }

    // Check for entity types.
    $schema = $this->getDatabase()->schema();
    Helper::sourceQueryAlter($query, $schema);

    // Exclude D7 default file_entity fields since they were renamed in D8.
    Helper::ignoreFields($query);

    return $query;
  }

}
