<?php

namespace Drupal\openfed_migrate\Plugin\migrate\source\taxonomy;

use Drupal\migrate\Row;
use Drupal\taxonomy\Plugin\migrate\source\d7\Term;

/**
 * Taxonomy term source from database.
 *
 * @MigrateSource(
 *   id = "d7_taxonomy_term_non_localized",
 *   source_module = "taxonomy"
 * )
 */
class OpenfedTermNonLocalized extends Term {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $query = parent::query();
    // For menu_to_taxonomy terms, we have a vocabulary per language and
    // therefore, we want to retrieve terms with i18n_mode = '0'.
    $query->condition('tv.i18n_mode', 0);
    // We need to sort the results to get always the same output.
    $query->orderBy('td.tid', 'ASC');
    return $query;
  }

}
