# OpenID Client Advanced

The **OpenID Client Advanced** module extends the Drupal [OpenID Connect](https://www.drupal.org/project/openid_connect) ecosystem with an OAuth 2.0/OIDC client plugin that supports automatic endpoint discovery, ID token signature validation, and nonce-based replay protection.

## Requirements
- Drupal core 10 or 11
- PHP 8.3 or higher
- `drupal/openid_connect` ^3.0
- `firebase/php-jwt` ^6.11 (installed automatically when using Composer)

## Installation
1. Add the module to your project (`composer require drupal/openid_client_advanced`) or place it in `modules/contrib`.
2. Enable the module (`drush en openid_client_advanced` or via **Extend**).
3. Clear caches if prompted.

## Configuring a client
1. Navigate to **Configuration → People → OpenID Connect** (`/admin/config/people/openid-connect`).
2. Add or edit a client and choose **OAuth 2.0 Advanced** as the client type.
3. Fill in the client credentials provided by your Identity Provider.
4. Configure the remaining fields as needed, then save.

### Endpoint discovery
- Enable **Auto discover endpoints** to populate Authorization, Token, UserInfo, and End Session endpoints via the provider's `.well-known/openid-configuration` document.
- Provide the **Issuer URL** when discovery is enabled. The module caches discovery responses per issuer.
- Disable discovery if your provider does not expose a discovery document and enter the endpoint URLs manually.

### Scopes and redirect behaviour
- Supply a space-separated list of scopes (defaults to `openid email`).
- The generated redirect URL is identical to the OpenID Connect module's base client; adjust allowed redirect URIs on the Identity Provider accordingly.

### ID token signature validation
- Enable **Validate ID token signature** to reject responses with untrusted signatures.
- Provide RSA/ECDSA public keys using either:
  - PEM-encoded keys separated by blank lines, or
  - A JWKS JSON document (`{"keys":[...]}`) copied from the provider's JWKS endpoint.
- Limit accepted algorithms with **Allowed signature algorithms** (space or comma separated, e.g. `RS256 RS512`).
- Validation failures are logged to the `openid_connect_advanced` channel.

### Nonce protection
- Enable **Send nonce parameter** to include a random nonce in authorization requests.
- The nonce is stored in the user session and verified against the `nonce` claim in the returned ID token.
- If the nonce is missing or mismatched, the authentication attempt is rejected and logged.

### Additional options
- **End Session endpoint** (optional) allows Drupal to initiate OpenID Connect logout when supported by the Identity Provider.
- The module exposes the `openid_client_advanced.jwt_signature_validator` service for custom integrations that need reusable JWT verification logic.

## Testing
- Execute unit tests from the Drupal root: `phpunit --testsuite openid_client_advanced` (or the equivalent command for your test runner).
- Tests cover nonce handling, signature validation, and JWKS parsing behaviour.
