# OpenID Client Advanced

The OpenID Client Advanced module provides an OAuth 2.0/OIDC client plugin working with the [OpenID Connect](https://www.drupal.org/project/openid_connect) module which accepts **file or environment variable** as the secret source, ID token **signature validation**, and **nonce-based** replay protection.

## Requirements
- Drupal core 10 or 11
- PHP 8.3 or higher
- `drupal/openid_connect` ^3.0
- `firebase/php-jwt` ^6.11 (installed automatically when using Composer)

## Installation
1. Add the module to your project (`composer require drupal/openid_client_advanced`) or place it in `modules/contrib`.
2. Enable the module (`drush en openid_client_advanced` or via **Extend**).
3. Clear caches if prompted.

## Configuring a client
1. Go to **Configuration → People → OpenID Connect** (`/admin/config/people/openid-connect`).
2. Add or edit a client and choose **OAuth 2.0 Advanced**.
3. Enter the **Client ID** and **Client secret**. Secrets can be inline, or you can supply YAML such as `file: path/to/secret` or `env: VARIABLE_NAME` to load from a file or environment variable.
4. Decide how endpoints are set:
   - Check **Auto discover endpoints** and provide an **Issuer URL** to pull endpoints from `/.well-known/openid-configuration`, or
   - Leave it unchecked and manually enter **Authorization**, **Token**, **UserInfo**, and **End Session** endpoints.
5. Set **Scopes** (space-separated, e.g. `openid email`) and save.

## Security features
- **Validate ID token signature:** Enable verification and provide RSA/ECDSA public keys as PEM (blank-line separated) or a JWKS JSON document. Optionally restrict **Allowed signature algorithms** (e.g. `RS256 RS512`). Failures log to `openid_connect_advanced`.
- **Send nonce parameter:** Include a nonce in authorization requests; the nonce is stored in the session and must match the `nonce` claim in the ID token or the login is rejected and logged.

## Testing
- Execute unit tests from the Drupal root: `phpunit --testsuite openid_client_advanced` (or the equivalent command for your test runner).
- Tests cover nonce handling, signature validation, and JWKS parsing behaviour.
