<?php

declare(strict_types=1);

namespace Drupal\opensearch_nlp\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure settings for Semantic Cache.
 */
class SemanticCacheSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'opensearch_nlp_semantic_cache_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['opensearch_nlp.semantic_cache_settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('opensearch_nlp.semantic_cache_settings');

    $form['semantic_cache_enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Semantic Cache'),
      '#description' => $this->t('Check this to enable the Semantic Cache feature.'),
      '#default_value' => $config->get('semantic_cache_enabled'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('opensearch_nlp.semantic_cache_settings')
      ->set('semantic_cache_enabled', $form_state->getValue('semantic_cache_enabled'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
