<?php

declare(strict_types=1);

namespace Drupal\opensearch_nlp\Plugin\search_api\data_type;

use Drupal\search_api\Plugin\search_api\data_type\TextDataType;

/**
 * Provides the text embedding (vector) data type.
 *
 * @SearchApiDataType(
 *   id = \Drupal\opensearch_nlp\Plugin\search_api\data_type\OpensearchTextEmbeddingVector::PLUGIN_ID,
 *   label = @Translation("Opensearch Text embedding Vector"),
 *   description = @Translation("Text embedding - semantic representation of textual data in vector space."),
 *   fallback_type = "text"
 * )
 */
final class OpensearchTextEmbeddingVector extends TextDataType {

  /**
   * The plugin ID.
   */
  public const string PLUGIN_ID = 'opensearch_text_embedding_vector';

}
