<?php

namespace Drupal\openwoo_publish\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\openwoo_publish\Entity\OpenWooPublicationInterface;

/**
 * Interface for OpenWooPublish plugins.
 */
interface OpenWooPublishPluginInterface extends PluginInspectionInterface, ContainerFactoryPluginInterface {

  /**
   * Returns the translated plugin label.
   *
   * @return string
   *   The translated title.
   */
  public function label(): string;

  /**
   * Returns the translated plugin description.
   *
   * @return string
   *   The translated title.
   */
  public function description(): string;

  /**
   * Adds a publication.
   *
   * @param \Drupal\openwoo_publish\Entity\OpenWooPublicationInterface $openwoo_publication
   *   The OpenWooPublication entity.
   *
   * @return string|null
   *   The response.
   */
  public function addPublication(OpenWooPublicationInterface $openwoo_publication): string|null;

  /**
   * Updates a publication.
   *
   * @param \Drupal\openwoo_publish\Entity\OpenWooPublicationInterface $openwoo_publication
   *   The OpenWooPublication entity.
   * @param string $external_id
   *   The external_id of the OpenWooPublication.
   *
   * @return string|null
   *   The response.
   */
  public function updatePublication(OpenWooPublicationInterface $openwoo_publication, string $external_id): string|null;

  /**
   * Deletes a publication.
   *
   * @param string $external_id
   *   The external_id of the OpenWooPublication.
   * @param string $schema_id
   *   (optional) The schema ID for the OpenWooPublication.
   *
   * @return string|null
   *   The response.
   */
  public function deletePublication(string $external_id, string $schema_id = ''): string|null;

  /**
   * Returns the form elements for the settings form.
   *
   * @return array
   *   A list of elements to show on the form.
   */
  public function getElements(): array;

  /**
   * Processes the submitted form values.
   *
   * This function is called when the parent form is submitted.
   *
   * @param array $form
   *   The form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   */
  public function submitElements(array $form, FormStateInterface $form_state);

}
