<?php

namespace Drupal\openwoo_search\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an OpenWoo Search plugin attribute object.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class OpenWooSearch extends Plugin {

  /**
   * Constructs a new \Drupal\openwoo_search\Attribute\OpenWooSearch object.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The plugin label.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $description
   *   The plugin description.
   * @param string|null $configName
   *   The configuration object name where the settings are stored.
   * @param class-string|null $deriver
   *   (optional) The plugin deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly TranslatableMarkup $description,
    public readonly ?string $configName = NULL,
    public readonly ?string $deriver = NULL,
  ) {}

}
