<?php

namespace Drupal\openwoo;

/**
 * Provides an interface for OpenWoo publication fields providers.
 */
interface OpenWooPublicationFieldsProviderInterface {

  /**
   * Returns the form fields for publications.
   *
   * @param array|null $values
   *   (optional) An array with (default) values for the form fields.
   *
   * @return array
   *   The form fields for publications.
   */
  public function getFormFields(?array $values): array;

  /**
   * Returns a 'human-readable' representation of a value for a given property.
   *
   * @param string $property
   *   The property to return a 'human-readable' value for.
   * @param mixed $value
   *   The (stored) value for the property.
   *
   * @return mixed
   *   The 'human-readable" representation of the value for the giver property.
   */
  public function getReadableValue(string $property, mixed $value): mixed;

}
