const merge = require('webpack-merge');
const common = require('./webpack.common.js');

module.exports = merge(common, {
  mode: 'development',
  watch: true,
  module: {
    rules: [
      {
        test: /\.js$/,
        exclude: [
          /node_modules/,
          /jshint-loader/,
          /webpack-entry.js/
        ],
        use: {
          loader: "babel-loader"
        }
      },
      {
        test: /\.s[ac]ss$/i,
        use: [
          'style-loader',

          {
            loader: 'css-loader',
            options: {
              url: false,
              sourceMap: true
            }
          },
          {
            loader: 'sass-loader',
            sassOptions: {
              includePaths: [
                "./node_modules/bootstrap/scss"
              ],
            },
            options: {
              sourceMap: true
            }
          }
        ]
      }
    ]
  }
});
