# Maintaining the theme.

## Compiling SASS to CSS

This theme uses SASS (Syntactically Awesome Style Sheets) to generate CSS. Follow these steps to compile:

### Quick Start (No sudo required)

1. From the theme directory root (docroot/themes/contrib/openy_lily or custom_contrib/openy_lily):
   ```bash
   bundle install --path vendor/bundle
   bundler exec compass compile
   ```

2. To watch for changes and auto-compile:
   ```bash
   bundler exec compass watch --poll
   ```

### Setup Details

The theme requires Ruby 2.6+ and bundler. Dependencies are listed in `Gemfile`:
- compass-aurora ~> 3.0.6
- toolkit ~> 1.0.0
- singularitygs ~> 1.4.0
- sass ~> 3.4.9
- breakpoint ~> 2.5.0
- sassy-buttons ~> 0.1.4
- compass-normalize ~> 1.4.3
- css_parser ~> 1.3.7

### Important Notes

- Always run `bundle install` before compiling to ensure gem versions match Gemfile.lock
- The `--path vendor/bundle` flag installs gems locally (no system access needed)
- Never commit `vendor/bundle/` directory to git
- SASS files are in `sass/` directory, compiled CSS goes to `css/` directory
- After compiling, clear Drupal cache: `ddev drush cr`

### Troubleshooting

If you see deprecation warnings during compilation, they're harmless and don't affect the output.

If `bundle install` fails:
- Ensure Ruby 2.6+ is installed: `ruby --version`
- Try: `bundle update --bundler` then `bundle install --path vendor/bundle` again
