# Require any additional compass plugins here.
require 'compass'
require 'breakpoint'
require 'aurora'

# Set this to the root of your project when deployed:
http_path = "/themes/custom/openy_lily"
css_dir = "css"
sass_dir = "sass"
images_dir = "img"
javascripts_dir = "scripts"
fonts_dir = "fonts"

# Change this to :production when ready to deploy the CSS to the live server.
# Note: If you are using grunt.js, these variables will be overriden.
environment = :development
#environment = :production

# To enable relative paths to assets via compass helper functions. Since Drupal themes can be installed in multiple locations, we shouldn't need to worry about the absolute path to the theme from the server root.
relative_assets = true

# To enable debugging comments that display the original location of your selectors. Comment:
line_comments = false

# In development, we can turn on the debug_info to use with FireSass or Chrome Web Inspector. Uncomment:
debug = false


##############################
## You probably don't need to edit anything below this.
##############################

# Disable cache busting on image assets
asset_cache_buster :none

# You can select your preferred output style here (can be overridden via the command line):
# output_style = :expanded or :nested or :compact or :compressed
output_style = (environment == :development) ? :expanded : :compressed

# Pass options to sass. For development, we turn on the FireSass-compatible
# debug_info if the debug config variable above is true.
sass_options = (environment == :development && debug == true) ? {:debug_info => true} : {}

# Generate sourcemaps
sourcemap = true
Encoding.default_external = "utf-8"
