<?php

declare(strict_types=1);

namespace Drupal\operation_example\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup as TM;
use Drupal\operation\Operator;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * {@selfdoc}
 */
final class ExampleForm extends FormBase {

  /**
   * {@selfdoc}
   */
  public function __construct(
    // @phpstan-ignore property.onlyWritten
    private Operator $operator,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new self(
      $container->get(Operator::class),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'operation_example';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {

    $form['operation'] = [
      '#type' => 'operation',
      '#operation' => '9e3990b7-e145-487d-afa8-14f72a58ecf5',
    ];
    $form['items'] = [
      '#title' => new TM('Number of items to process'),
      '#type' => 'number',
      '#min' => 0,
    ];
    $form['actions'] = [
      '#type' => 'actions',
      'start' => [
        '#type' => 'submit',
        '#value' => new TM('Start'),
        '#button_type' => 'primary',
        '#name' => 'start',
        '#executes_submit_callback' => FALSE,
      ],
      'pause' => [
        '#type' => 'submit',
        '#value' => new TM('Pause'),
        '#name' => 'pause',
        '#executes_submit_callback' => FALSE,
      ],
      'cancel' => [
        '#type' => 'submit',
        '#value' => new TM('Cancel'),
        '#button_type' => 'danger',
        '#name' => 'cancel',
        '#executes_submit_callback' => FALSE,
      ],
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->messenger()->addStatus(new TM('Submitted.'));
  }

}
