<?php

declare(strict_types=1);

namespace Drupal\operation_example\Plugin\QueueWorker;

use Drupal\Core\Queue\Attribute\QueueWorker;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\operation\Plugin\QueueWorker\OperationWorkerBase;

#[QueueWorker(
  id: 'example',
  title: new TranslatableMarkup('Example'),
)]
final class Example extends OperationWorkerBase {

  /**
   * {@selfdoc}
   */
  protected function doProcessItem(mixed $payload): array {
    \sleep(1);
    return ['data' => \mt_rand()];
  }

}
