<?php

declare(strict_types=1);

namespace Drupal\operation\Command;

use Drupal\operation\Operator;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

/**
 * {@selfdoc}
 */
#[AsCommand(
  name: 'operation:list',
  description: 'Displays all operations.',
)]
final class ListOperations extends Command {

  /**
   * {@inheritdoc}
   */
  public function __construct(private readonly Operator $operator) {
    parent::__construct();
  }

  /**
   * {@inheritdoc}
   */
  protected function execute(InputInterface $input, OutputInterface $output): int {
    $io = new SymfonyStyle($input, $output);
    $table = $io->createTable();

    $table->setHeaders(['ID', 'Status', 'Processed Jobs', 'Total Jobs', 'Created', 'Updated']);
    foreach ($this->operator->getAllOperations() as $operation) {
      $row = [
        $operation->id->value,
        $operation->status->value,
        $operation->processedJobs,
        $operation->totalJobs,
        $operation->created->format('d.m.Y H:i:s'),
        $operation->updated->format('d.m.Y H:i:s'),
      ];
      $table->addRow($row);
    }
    $table->render();

    return self::SUCCESS;
  }

}
