<?php

declare(strict_types=1);

namespace Drupal\operation\Controller;

use Drupal\operation\Data\Operation;
use Drupal\operation\Data\OperationId;
use Drupal\operation\Exception\OperationNotFound;
use Drupal\operation\Operator;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * {@selfdoc}
 */
final readonly class OperationController {

  /**
   * {@selfdoc}
   */
  public function __construct(private Operator $operator) {}

  /**
   * {@selfdoc}
   */
  public function __invoke(string $operation_id): JsonResponse {
    try {
      $operation = $this->operator->getOperation(new OperationId($operation_id));
    }
    catch (\InvalidArgumentException | OperationNotFound) {
      return new JsonResponse(status: 404);
    }
    return new JsonResponse(
      self::normalize($operation),
    );
  }

  /**
   * {@selfdoc}
   */
  private static function normalize(Operation $operation): array {
    return [
      'id' => $operation->id->value,
      'status' => $operation->id->value,
      'created' => $operation->created->format(\DateTimeInterface::ATOM),
      'updated' => $operation->updated->format(\DateTimeInterface::ATOM),
      'totalJobs' => $operation->totalJobs,
      'processedJobs' => $operation->processedJobs,
      'result' => $operation->result,
    ];
  }

}
