<?php

declare(strict_types=1);

namespace Drupal\operation\Data;

/**
 * {@selfdoc}
 */
final readonly class JobOutput {

  /**
   * {@selfdoc}
   */
  public function __construct(
    public JobId $jobId,
    public OperationId $operationId,
    public mixed $output,
  ) {}

  /**
   * {@selfdoc}
   */
  public static function fromJobInput(JobInput $job_input, mixed $output): self {
    return new self(
      jobId: $job_input->jobId,
      operationId: $job_input->operationId,
      output: $output,
    );
  }

}
