<?php

declare(strict_types=1);

namespace Drupal\operation\Data;

/**
 * {@selfdoc}
 */
final readonly class OperationId implements \Stringable {

  /**
   * {@selfdoc}
   */
  public function __construct(
    public string $value,
  ) {
    if (\strlen($value) !== 36) {
      throw new \InvalidArgumentException('Operation ID must be exactly 36 characters long.');
    }
  }

  /**
   * {@inheritdoc}
   */
  public function __toString(): string {
    return $this->value;
  }

}
