<?php

declare(strict_types=1);

namespace Drupal\operation\Exception;

use Drupal\operation\Data\OperationId;

/**
 * {@selfdoc}
 */
final class OperationNotFound extends \InvalidArgumentException {

  /**
   * {@inheritdoc}
   */
  public function __construct(OperationId $operation_id) {
    parent::__construct(
      \sprintf('Operation "%s" was not found.', $operation_id->value),
    );
  }

}
