<?php

declare(strict_types=1);

namespace Drupal\operation\Exception;

use Drupal\operation\Data\OperationStatus;

/**
 * {@selfdoc}
 */
final class OperationStatusTransition extends \LogicException {

  /**
   * {@inheritdoc}
   */
  public function __construct(OperationStatus $current_status, OperationStatus $next_status) {
    parent::__construct(
      \sprintf('Cannot transition operation status from "%s" to "%s".', $current_status->value, $next_status->value),
    );
  }

}
